/*
  07/12/2021 Sergio Rinaldi: TFS: 159171
  --------------------------------------
*/

SET NOCOUNT ON 
 
IF OBJECT_ID(N'tempdb..#CGW1', N'U') IS NOT NULL
  DROP TABLE #CGW1
;

SELECT
    CGW1_CODICE
  , CGW1_CODICE_CGW0
  , CGW1_DESCRIZIONE
  , CGW1_DESCRTIPOWS
  , CGW1_URL
  , CGW1_FLGPERS
INTO #CGW1 
FROM CGW1_WEBSERVICE WITH(NOLOCK)
WHERE 1 = 0
;
DECLARE @CGW0_CDC   AS INT = 1

INSERT #CGW1 VALUES (@CGW0_CDC+0, @CGW0_CDC, 'Autenticazione', 'Comunicazione liquidazioni periodiche IVA e dati fatture','https://b2b-auth-service.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_CDC+1, @CGW0_CDC, 'Invio file', 'Comunicazione liquidazioni periodiche IVA e dati fatture','https://liquid-iva.agyo.io/v2',0);
INSERT #CGW1 VALUES (@CGW0_CDC+2, @CGW0_CDC, 'Company registry', 'Comunicazione liquidazioni periodiche IVA e dati fatture','https://registry-read.agyo.io/api',0);

MERGE INTO CGW1_WEBSERVICE AS Target 
USING (SELECT * FROM #CGW1) AS Source 
   ON (Target.CGW1_CODICE = Source.CGW1_CODICE AND Target.CGW1_CODICE_CGW0 = Source.CGW1_CODICE_CGW0) 
WHEN MATCHED THEN
    UPDATE SET Target.CGW1_CODICE      = Source.CGW1_CODICE
             , Target.CGW1_CODICE_CGW0 = Source.CGW1_CODICE_CGW0
             , Target.CGW1_DESCRIZIONE = Source.CGW1_DESCRIZIONE
             , Target.CGW1_DESCRTIPOWS = Source.CGW1_DESCRTIPOWS
             , Target.CGW1_URL         = Source.CGW1_URL
             , Target.CGW1_FLGPERS     = Source.CGW1_FLGPERS
WHEN NOT MATCHED THEN
    INSERT (  CGW1_CODICE
            , CGW1_CODICE_CGW0
            , CGW1_DESCRIZIONE
            , CGW1_DESCRTIPOWS
            , CGW1_URL
            , CGW1_FLGPERS
           )
    VALUES (  Source.CGW1_CODICE
            , Source.CGW1_CODICE_CGW0
            , Source.CGW1_DESCRIZIONE
            , Source.CGW1_DESCRTIPOWS
            , Source.CGW1_URL
            , Source.CGW1_FLGPERS
           )
;


IF OBJECT_ID(N'tempdb..#CGW1', N'U') IS NOT NULL
    DROP TABLE #CGW1
;